<?php $__env->startSection('header.title'); ?>
Better Work Indonesia | User Dashboard
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="content-header">
	<div class="container-fluid">
      	<div class="row mb-2">
       		<div class="col-sm-6">
          		<h1>User Dashboard</h1>
       		</div>
       	</div>
    </div>
</section>
<section class="content">
	<div class="container-fluid">
		<?php if(count($errors) > 0): ?> 
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<h5><i class="icon fas fa-ban"></i> Alert!</h5>
				<ul>
					<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<li><?php echo e($error); ?></li>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</ul>
			</div>
        <?php endif; ?>
		<div class="row">
			<div class="col-md-3">
				<div class="card card-primary card-outline">
					<div class="card-body box-profile">
						<div class="text-center">
							<img class="profile-user-img img-fluid img-circle"
                       			src="/employees/<?php echo e($getBasicProfile->picture); ?>"
                       			alt="User profile picture">
                  			<!--<img class="profile-user-img img-fluid img-circle"
                       			src="http://betterwork.local/public/employees/<?php echo e($getBasicProfile->picture); ?>"
                       			alt="User profile picture">-->
                		</div>
                		<h3 class="profile-username text-center"><?php echo e(isset(Auth::user()->name) ? Auth::user()->name : Auth::user()->email); ?></h3>
                		<p class="text-muted text-center">
						<?php echo e($getCurPos->grade); ?>

						</p>
                		<ul class="list-group list-group-unbordered mb-3">
                  			<li class="list-group-item">
                    			<b>Days In Company</b> <a class="float-right"><?php echo e($totalDays); ?></a>
                  			</li>
                  			<li class="list-group-item">
                    			<b>This Year Leave (Days)</b> <a class="float-right"><?php echo e($getBasicProfile->leave_amount); ?></a>
                  			</li>
                  			<li class="list-group-item">
                    			<b>This Year Leave Taken (Days)</b> <a class="float-right"><?php echo e($getBasicProfile->leave_remaining); ?></a>
                  			</li>
                		</ul>
                	</div>
                </div>
                <div class="card card-danger">
                	<div class="card-header">
                		<h3 class="card-title"><i class="fas fa-user-clock"></i> Attendance</h3>
              		</div>
              		<div class="card-body">
              			<div class="row">
	              			<div class="col-md-4">
								<?php if(($getAttendance) == null): ?>
									<a class="btn" data-toggle="modal" data-target="#clock-in"><img src="https://img.icons8.com/carbon-copy/100/000000/circled-play.png"/>Clock In</a>
								<?php endif; ?>
								<?php if(($getAttendance) != null): ?>
									<?php if(($getAttendance->status_id) != 'f4f23f41-0588-4111-a881-a043cf355831'): ?>
										<a class="btn" data-toggle="modal" data-target="#clock-in"><img src="https://img.icons8.com/carbon-copy/100/000000/circled-play.png"/>Clock In</a>
									<?php else: ?>
										<a class="btn" data-toggle="modal" data-target="#clock-out"><img src="https://img.icons8.com/dotty/80/000000/stop-circled.png"/>Clock Out</a>
									<?php endif; ?>
								<?php endif; ?>
								<div class="modal fade" id="clock-in">
									<div class="modal-dialog modal-lg">
										<div class="modal-content">
											<div class="modal-header">
												<h4 class="modal-title">Today Task Planning</h4>
													<button type="button" class="close" data-dismiss="modal" aria-label="Close">
														<span aria-hidden="true">&times;</span>
													</button>
											</div>
											<div class="modal-body">
												<?php echo Form::open(array('route' => 'attendanceIn.store','method'=>'POST')); ?>

												<?php echo csrf_field(); ?>
												<div class="form-group">
													<label class="col-sm-2 col-form-label">Task List</label>
													<?php echo Form::textarea('notes', null, array('placeholder' => 'Plan Task For Today','class' => 'form-control')); ?>

												</div>
											</div>
											<div class="modal-footer">
												<button type="close" class="btn btn-sm btn-danger" data-dismiss="modal">Close</button>
												<button type="submit" class="btn btn-sm btn-success">Clock In</button>
											</div>
											<?php echo Form::close(); ?>

										</div>
									</div>
								</div>
								<div class="modal fade" id="clock-out">
									<div class="modal-dialog modal-lg">
										<div class="modal-content">
											<div class="modal-header">
												<h4 class="modal-title">Today Task Outcome</h4>
													<button type="button" class="close" data-dismiss="modal" aria-label="Close">
														<span aria-hidden="true">&times;</span>
													</button>
											</div>
											<div class="modal-body">
												<?php echo Form::open(array('route' => 'attendanceOut.store','method'=>'POST')); ?>

												<?php echo csrf_field(); ?>
												<div class="form-group">
													<label class="col-sm-2 col-form-label">Task List</label>
													<?php if(($getAttendance) != null): ?>
													<?php $__currentLoopData = $getAttendance->Activity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<?php echo Form::textarea('notes', $activity->notes, array('placeholder' => 'Today Task Outcome','class' => 'form-control')); ?>

													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													<?php else: ?>
														<?php echo Form::textarea('notes', null, array('placeholder' => 'Today Task Outcome','class' => 'form-control')); ?>

													<?php endif; ?>
												</div>
											</div>
											<div class="modal-footer">
												<button type="close" class="btn btn-sm btn-danger" data-dismiss="modal">Close</button>
												<button id="register" type="submit" class="btn btn-sm btn-success">Clock Out</button>
											</div>
											<?php echo Form::close(); ?>

										</div>
									</div>
								</div>
	              			</div>
	              			<div class="col-md-8">
							<?php if(($getAttendance) != null): ?>
								<?php $__currentLoopData = $getAttendance->Activity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<p> In : <?php if(!empty($act->clock_in)): ?><?php echo e(date("d F Y H:i",strtotime($act->clock_in))); ?><?php endif; ?></p>
									<p> Out : <?php if(!empty($act->clock_out)): ?><?php echo e(date("d F Y H:i",strtotime($act->clock_out))); ?><?php endif; ?></p>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php if(!empty($getAttendance->working_hour)): ?><p> Worked For <span class="badge badge-danger"><?php echo e($getAttendance->working_hour); ?></span> Hour Today</p><?php endif; ?>
							<?php else: ?>
								<p> In : </p>
								<p> Out : </p>
								<p> Worked For <span class="badge badge-danger">...</span> Hour Today</p>
							<?php endif; ?>
	              			</div>
							<div class="col-md-12">
								<p>Today Task :</p>
								<?php if(($getAttendance) != null): ?>
								<textarea class="form-control" rows="10" readonly><?php $__currentLoopData = $getAttendance->Activity; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($act->notes); ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></textarea>
								<?php else: ?>
								<textarea class="form-control" rows="10" readonly></textarea>
								<?php endif; ?>
								<br>
								<?php if(($getAttendance) != null): ?>
								<?php if($getAttendance->status_id == 'f4f23f41-0588-4111-a881-a043cf355831'): ?>
								<a class="btn btn-sm btn-danger" data-toggle="modal" data-target="#edit-task">Edit Task</a>
								<?php endif; ?>
								<?php endif; ?>
								<div class="modal fade" id="edit-task">
									<div class="modal-dialog modal-lg">
										<div class="modal-content">
											<div class="modal-header">
												<h4 class="modal-title">Today Task Edit</h4>
													<button type="button" class="close" data-dismiss="modal" aria-label="Close">
														<span aria-hidden="true">&times;</span>
													</button>
											</div>
											<div class="modal-body">
												<?php echo Form::open(array('route' => 'attendanceTask.update','method'=>'POST', 'class' => 'form-horizontal')); ?>

												<?php echo csrf_field(); ?>
												<div class="form-group row">
													<label class="col-sm-2 col-form-label">Task List</label>
													<?php if(($getAttendance) != null): ?>
													<?php echo Form::textarea('notes', $act->notes , array('placeholder' => 'Attendance Note','class' => 'form-control')); ?>

													<?php else: ?>
													<?php echo Form::textarea('notes', null , array('placeholder' => 'Attendance Note','class' => 'form-control')); ?>

													<?php endif; ?>
												</div>
											</div>
											<div class="modal-footer">
												<button type="close" class="btn btn-sm btn-danger" data-dismiss="modal">Close</button>
												<button type="submit" class="btn btn-sm btn-success">Submit</button>
											</div>
											<?php echo Form::close(); ?>

										</div>
									</div>
								</div>
							</div>
	              		</div>
              		</div>
              	</div>
            </div>
            <div class="col-md-9">
            	<div class="card">
            		<div class="card-header p-2">
                		<ul class="nav nav-pills">
                  			<li class="nav-item"><a class="nav-link active" href="#overview" data-toggle="tab">Overview</a></li>
                        	<li class="nav-item"><a class="nav-link" href="#organization" data-toggle="tab">Organization</a></li>
                        	<li class="nav-item"><a class="nav-link" href="#fams" data-toggle="tab">Family</a></li>
                  			<li class="nav-item"><a class="nav-link" href="#salary" data-toggle="tab">Salary Slips</a></li>
                        	<li class="nav-item"><a class="nav-link" href="#historical" data-toggle="tab">Service History</a></li>
                  			<li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Change Password</a></li>
                		</ul>
              		</div>
              		<div class="card-body">
              			<div class="tab-content">
              				<div class="active tab-pane" id="overview">
								<strong><i class="fas fa-calendar-check mr-1"></i> Birthday</strong>
								<p class="text-muted"><?php echo e(date("d F Y",strtotime($getBasicProfile->date_of_birth))); ?></p>
								<strong><i class="fas fa-book mr-1"></i> Education</strong>
              					<p class="text-muted">
								<?php if(!empty($getLastEdu)): ?>
                  					<?php echo e($getLastEdu->grade); ?> in <?php echo e($getLastEdu->major); ?> from <?php echo e($getLastEdu->institution_name); ?>

								<?php endif; ?>
								</p>
                				<hr>
                				<strong><i class="fas fa-map-marker-alt mr-1"></i> Home Address</strong>
                				<p class="text-muted"><?php echo e($getBasicProfile->address); ?></p>
                				<hr>
                				<strong><i class="fas fa-pencil-alt mr-1"></i> Training & Certification</strong>
                				<p class="text-muted">
								<?php if(!empty($getTraining)): ?>
								<?php $__currentLoopData = $getTraining; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $training): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  					<span class="tag tag-danger"><?php echo e($training->training_title); ?></span>
                  				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php endif; ?>
                				</p>
                				<hr>
								<strong><i class="fas fa-pencil-alt mr-1"></i> Contract Download</strong>
              				</div>
							<div class="tab-pane" id="organization">
								<strong><i class="fas fa-id-badge mr-1"></i> Employee ID</strong>
								<p class="text-muted">
									<?php echo e($getBasicProfile->employee_no); ?>

								</p>
								<strong><i class="fas fa-calendar-check mr-1"></i> Join Date</strong>
								<p class="text-muted">
									<?php echo e(date("d F Y",strtotime($getBasicProfile->from))); ?>

								</p>
								<strong><i class="fas fa-file-signature mr-1"></i> Employment Type</strong>
								<p class="text-muted">
									<?php echo e($getBasicProfile->Contracts->name); ?>

								</p>
								<strong><i class="fas fa-clipboard-check mr-1"></i> Current Position</strong>
								<p class="text-muted">
									<?php echo e($getCurPos->grade); ?>

								</p>
								<strong><i class="fas fa-user-tie mr-1"></i> Direct Supervisor</strong>
								<p class="text-muted">
									<?php if(isset($getCurPos->report_to)): ?>
										<?php echo e($getCurPos->Reporting->first_name); ?> <?php echo e($getCurPos->Reporting->last_name); ?>

									<?php endif; ?>
								</p>
								<strong><i class="fas fa-user-friends mr-1"></i> Direct Subordinate</strong>
								<table class="table table-bordered">
									<thead>
										<tr>
											<th style="width: 10px">#</th>
											<th>Photo</th>
											<th>Name</th>
											<th>Position</th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $getSubordinate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($key+1); ?></td>
											<td>
												<img src="http://betterwork.iteos.tech/employees/<?php echo e($value->Parent->picture); ?>" class="img-circle elevation-2" alt="User Image" style="width: 50px; height: 50px;">
											</td>
											<!--<td>
												<img src="http://betterwork.local/public/employees/<?php echo e($value->Parent->picture); ?>" class="img-circle elevation-2" alt="User Image" style="width: 50px; height: 50px;">
											</td>-->
											<td><?php echo e($value->Parent->first_name); ?> <?php echo e($value->Parent->last_name); ?></td>
											<td><?php echo e($value->grade); ?></td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
							<div class="tab-pane" id="organization">
		                        <strong><i class="fas fa-id-badge mr-1"></i> Employee ID</strong>
		                        <p class="text-muted">
		                            <?php echo e($getEmployee->employee_no); ?>

		                        </p>
		                        <strong><i class="fas fa-calendar-check mr-1"></i> Join Date</strong>
		                        <p class="text-muted">
		                            <?php echo e(date("d F Y",strtotime($getBasicProfile->from))); ?>

		                        </p>
		                        <strong><i class="fas fa-file-signature mr-1"></i> Employment Type</strong>
		                        <p class="text-muted">
		                            <?php echo e($getEmployee->Contracts->name); ?>

		                        </p>
		                        <strong><i class="fas fa-clipboard-check mr-1"></i> Current Position</strong>
		                        <p class="text-muted">
		                            <?php echo e($getServices->grade); ?>

		                        </p>
		                        <strong><i class="fas fa-user-tie mr-1"></i> Direct Supervisor</strong>
		                        <p class="text-muted">
		                          <?php if(isset($getServices->report_to)): ?>
		                          <?php echo e($getServices->Reporting->first_name); ?> <?php echo e($getServices->Reporting->last_name); ?>

		                          <?php endif; ?>
		                        </p>
		                        <strong><i class="fas fa-user-friends mr-1"></i> Direct Subordinate</strong>
                        		<table class="table table-bordered">
	                          		<thead>
			                            <tr>
			                              <th style="width: 10px">#</th>
			                              <th>Avatar</th>
			                              <th>Name</th>
			                              <th>Position</th>
			                            </tr>
	                          		</thead>
	                          		<tbody>
	                            		<?php $__currentLoopData = $getSubordinate; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			                            <tr>
			                              	<td><?php echo e($key+1); ?></td>
			                              	<td>
												<img src="http://betterwork.iteos.tech/public/employees/<?php echo e($value->Parent->picture); ?>" class="img-circle elevation-2" alt="User Image" style="width: 50px; height: 50px;">
											</td>
											<td><?php echo e($value->Parent->first_name); ?> <?php echo e($value->Parent->last_name); ?></td>
			                              	<td><?php echo e($value->grade); ?></td>
			                            </tr>
	                            		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	                          		</tbody>
                        		</table>
                      		</div>
                      		<div class="tab-pane" id="fams">
                      			<table class="table table-bordered">
                          			<thead>
                            			<tr>
			                              	<th style="width: 10px">#</th>
			                              	<th>Name</th>
			                              	<th>Relation</th>
			                              	<th>Address</th>
			                              	<th>Phone</th>
			                              	<th>Mobile</th>
                            			</tr>
                          			</thead>
                          			<tbody>
                          				<?php $__currentLoopData = $getFamily; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $family): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            			<tr>
			                              	<td><?php echo e($key+1); ?></td>
			                              	<td><?php echo e($family->first_name); ?> <?php echo e($family->last_name); ?></td>
			                              	<td>
			                              		<?php if($family->relations == '1'): ?>
													Husband
												<?php elseif($family->relations == '2'): ?>
													Wife
												<?php elseif($family->relations == '3'): ?>
													Parent
												<?php else: ?>
													Sibling
												<?php endif; ?>
			                              	</td>
			                              	<td><?php echo e($family->address); ?></td>
			                              	<td><?php echo e($family->phone); ?></td>
			                              	<td><?php echo e($family->mobile); ?></td>
                            			</tr>
                            			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          			</tbody>
                        		</table>
                      		</div>
              				<div class="tab-pane" id="salary">
              					<table class="table table-bordered">
              						<thead>
              							<tr>
              								<th style="width: 10px">#</th>
              								<th>Period</th>
              								<th>Slip</th>
              							</tr>
              						</thead>
              						<tbody>
										<?php if(!empty($getSalary)): ?>
										<?php $__currentLoopData = $getSalary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              							<tr>
              								<td><?php echo e($key+1); ?></td>
              								<td><?php echo e(date("F Y",strtotime($value->payroll_period))); ?></td>
              								<td> 
												<a href="<?php echo e(route('mySalary.export',['empNo'=>$value->employee_no])); ?>" class="btn btn-sm btn-info"><i class="fas fa-file-pdf"></i></a>
												<a href="<?php echo e(route('mySalary.print',['empNo'=>$value->employee_no])); ?>" target="blank" class="btn btn-sm btn-info"><i class="fas fa-print"></i></a>
											</td>
              							</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										<?php else: ?>
										<tr>
											<td></td>
											<td></td>
										</tr>
										<?php endif; ?>
									</tbody>
              					</table>
              				</div>
							<div class="tab-pane" id="historical">
								<table class="table table-bordered">
									<thead>
										<tr>
											<th>Position</th>
											<th>From</th>
											<th>To</th>
											<th>Supervisor</th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $getEmployee->Services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($service->grade); ?></td>
											<td><?php echo e(date("d F Y",strtotime($service->from))); ?></td>
											<td>
												<?php if(!empty($service->to)): ?>
													<?php echo e(date("d F Y",strtotime($service->to))); ?>

												<?php endif; ?>
											</td>
											<td>
												<?php if(!empty($service->report_to)): ?>
												<?php echo e($service->Reporting->first_name); ?> <?php echo e($service->Reporting->last_name); ?>

												<?php endif; ?>
											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							</div>
              				<div class="tab-pane" id="settings">
								<?php echo Form::open(array('route' => 'userPassword.update','method'=>'POST', 'class' => 'form-horizontal')); ?>

								<?php echo csrf_field(); ?>
              					<div class="form-group row">
									<label for="inputEmail" class="col-sm-2 col-form-label">New Password</label>
									<?php echo Form::password('password', array('placeholder' => 'Password','class' => 'form-control')); ?>

                        		</div>
								<div class="form-group row">
									<label for="inputEmail" class="col-sm-2 col-form-label">Confirm New Password</label>
									<?php echo Form::password('confirm-password', array('placeholder' => 'Confirm Password','class' => 'form-control')); ?>

								</div>
								<div class="form-group row">
									<button type="submit" class="btn btn-sm btn-success">Reset</button>
								</div>
								<?php echo Form::close(); ?>

							</div>
                      	</div>
                    </div>
              	</div>
				<div class="row">
					<div class="col-md-6">
						<div class="card card-info">
							<div class="card-header">
								<h3 class="card-title"><i class="fab fa-blogger"></i> Bulletin Board</h3>
							</div>
							<div class="card-body">
								<div class="card-body table-responsive p-0" style="height: 300px;">
									<table class="table table-head-fixed text-nowrap">
										<thead>
											<tr>
												<th style="width: 10px;">No</th>
												<th>Title</th>
												<th style="width: 10px;"></th>
											</tr>
										</thead>
										<tbody>
											<?php $__currentLoopData = $getBulletin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$bulletin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td style="width: 10px;"><?php echo e($key+1); ?></td>
												<td><strong><?php echo e($bulletin->title); ?></strong></td>
												<td style="width: 10px;">
													<a class="btn btn-xs btn-success" href="<?php echo e(route('myBulletin.show',$bulletin->id)); ?> " title="Read Article" ><i class="fa fa-search"></i></a>
												</td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-6">
						<div class="card card-success">
							<div class="card-header">
								<h3 class="card-title"><i class="fas fa-birthday-cake"></i> This Month Birthday</h3>
							</div>
							<div class="card-body">
								<div class="card-body table-responsive p-0" style="height: 300px;">
									<table class="table table-head-fixed text-nowrap">
										<thead>
											<tr>
												<th style="width: 10px;">Date</th>
												<th>Employee Name</th>
											</tr>
										</thead>
										<tbody>
											<?php $__currentLoopData = $getBirthday; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$birthday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr>
												<td><?php echo e(date("d F",strtotime($birthday->date_of_birth))); ?></td>
												<td><?php echo e($birthday->first_name); ?> <?php echo e($birthday->last_name); ?></td>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>
						</div>
					</div>
				</div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer.scripts'); ?>
<script src="https://unpkg.com/ionicons@5.4.0/dist/ionicons.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('apps.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\betterwork-master\resources\views/apps/pages/userHome.blade.php ENDPATH**/ ?>